/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.chickens;

import net.creeperhost.chickens.ChickensClient;
import net.creeperhost.chickens.compat.top.TheOneProbePlugin;
import net.creeperhost.chickens.config.ConfigHandler;
import net.creeperhost.chickens.init.ModBlocks;
import net.creeperhost.chickens.init.ModChickens;
import net.creeperhost.chickens.init.ModContainers;
import net.creeperhost.chickens.init.ModEntities;
import net.creeperhost.chickens.init.ModItems;
import net.creeperhost.chickens.init.ModScreens;
import net.creeperhost.chickens.registry.LiquidEggRegistry;
import net.creeperhost.chickens.registry.LiquidEggRegistryItem;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chickens")
public class ChickensMod {
    public static final String MODID = "chickens";
    public static final Logger LOGGER = LogManager.getLogger();

    public ChickensMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ConfigHandler.LoadConfigs(ModChickens.generateDefaultChickens());
        ModBlocks.BLOCKS.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModBlocks.TILES_ENTITIES.register(eventBus);
        ModContainers.CONTAINERS.register(eventBus);
        ModEntities.ENTITIES.register(eventBus);
        this.registerLiquidEggs();
        eventBus.addListener(this::clientInit);
        eventBus.addListener(this::commonInit);
        if (ModList.get().isLoaded("theoneprobe")) {
            InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", TheOneProbePlugin.GetTheOneProbe::new);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void commonInit(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> ConfigHandler.MAP.forEach((chickensRegistryItem, s) -> {
            ItemStack stack = new ItemStack((ItemLike)Registry.f_122827_.m_7745_(new ResourceLocation(s.getItem())));
            if (stack.m_41619_()) {
                LOGGER.error("unable to get itemstack for " + chickensRegistryItem.getRegistryName() + " for itemstack: " + s);
            }
            try {
                if (!s.getNbt().isEmpty()) {
                    CompoundTag tag = TagParser.m_129359_((String)s.getNbt());
                    stack.m_41751_(tag);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            chickensRegistryItem.setLayItem(stack);
            chickensRegistryItem.setDropItem(stack);
        }));
    }

    private void clientInit(FMLClientSetupEvent event) {
        ModScreens.init();
        event.enqueueWork(ChickensClient::init);
    }

    public void registerLiquidEggs() {
        LiquidEggRegistry.register(new LiquidEggRegistryItem(0, Blocks.f_49990_, 255, (Fluid)Fluids.f_76193_));
        LiquidEggRegistry.register(new LiquidEggRegistryItem(1, Blocks.f_49991_, 0xFF0000, (Fluid)Fluids.f_76195_));
    }
}

